/**
 * ---------------------------------------------------------------------
 *
 * GLPI - Gestionnaire Libre de Parc Informatique
 *
 * http://glpi-project.org
 *
 * @copyright 2015-2025 Teclib' and contributors.
 * @copyright 2003-2014 by the INDEPNET Development Team.
 * @licence   https://www.gnu.org/licenses/gpl-3.0.html
 *
 * ---------------------------------------------------------------------
 *
 * LICENSE
 *
 * This file is part of GLPI.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * ---------------------------------------------------------------------
 */
import{GlpiFormConditionVisibilityEditorController}from"/js/modules/Forms/ConditionVisibilityEditorController.js";import{GlpiFormConditionValidationEditorController}from"/js/modules/Forms/ConditionValidationEditorController.js";export class GlpiFormEditorController{#t;#e;#i;#o;#a;#n;#s;#r;#d=false;#l=false;constructor(t,e,i,o,a,n){this.#t=t;this.#e=e;this.#i=i;this.#o=o;this.#a=a;this.#n={};this.#s={};this.#r=[];this.#l=n;if($(this.#t).prop("tagName")!="FORM"){throw new Error("Target must be a valid form")}this.#c();this.#p();this.#m();if(!this.#l){if(this.#f(this.#i).length==0){throw new Error(`Invalid default question type: ${i}`)}this.#g($(this.#t).find("[data-glpi-form-editor-blocks]"));if(this.#h()===0){$(this.#t).find("[data-glpi-form-editor-form-details-name]")[0].select()}}this.computeState();this.#u()}#p(){const t=_.throttle(()=>this.#c(),100);$(window).on("resize",()=>t());$(this.#t).on("glpi-ajax-controller-submit-success",()=>this.#v());$(document).on("click","[data-glpi-form-editor]",()=>{$(".simulate-focus").removeClass("simulate-focus")});$(document).on("tinyMCEChange",(t,e)=>this.#b(e));$(document).on("tinyMCEClick",(t,e)=>this.#$(e));$(document).on("show.bs.dropdown","[data-glpi-form-editor-visibility-dropdown]",t=>this.#y($(t.target).parent().find("[data-glpi-conditions-editor-container]")));$(document).on("show.bs.dropdown","[data-glpi-form-editor-validation-dropdown]",t=>this.#k($(t.target).parent().find("[data-glpi-conditions-editor-container]")));$(this.#t).on("submit",t=>{try{t.originalEvent.submitter.focus();this.computeState()}catch(e){t.preventDefault();t.stopPropagation();glpi_toast_error(__("An unexpected error occurred"));throw e}});$(this.#t).on("glpi-ajax-controller-submit-success",()=>{const t=$(this.#t).find("[data-glpi-form-editor-save-and-preview-action]");this.#C();if(this.#d){window.open(t.data("glpi-form-editor-preview-url"),"_blank");this.#d=false}});$(document).on("glpiFormChangeEvent",()=>{this.#C()});document.addEventListener("updated_strategy",t=>{this.#S($(t.detail.container).closest("[data-glpi-form-editor-block],[data-glpi-form-editor-section-details],[data-glpi-form-editor-container]"),t.detail.strategy)});document.addEventListener("conditions_count_changed",t=>{this.#I($(t.detail.container).closest("[data-glpi-form-editor-question-extra-details]"),t.detail.conditions_count)});$(document).on("select2:selecting",t=>{$(t.target).data("previous-value",$(t.target).val())});const e=["click","change","input"];e.forEach(t=>{const e=`data-glpi-form-editor-on-${t}`;$(document).on(t,`${this.#t} [${e}]`,async t=>{const i=$(t.currentTarget);const o=i.attr(e);try{await this.#_(o,i,t)}catch(t){glpi_toast_error(__("An unexpected error occurred"));throw t}})})}registerQuestionTypeOptions(t,e){this.#n[t]=e}registerQuestionSubTypesOptions(t,e){this.#s[t]=e}#v(){if(this.#e){this.#w()}}async#_(t,e,i){let o=true;i.stopPropagation();switch(t){case"set-active":this.#q(e);o=false;break;case"add-question":this.#E(e.closest(`\n                        [data-glpi-form-editor-active-form],\n                        [data-glpi-form-editor-active-section],\n                        [data-glpi-form-editor-active-horizontal-blocks],\n                        [data-glpi-form-editor-active-question],\n                        [data-glpi-form-editor-active-comment],\n                        [data-glpi-form-editor-horizontal-block-placeholder]\n                    `));break;case"delete-question":this.#z(e.closest("[data-glpi-form-editor-question]"));break;case"change-question-type-category":await this.#T(e.closest("[data-glpi-form-editor-question]"),e.val());break;case"change-question-type":await this.#A(e.closest("[data-glpi-form-editor-question]"),e.val());break;case"change-question-sub-type":this.#x(e.closest("[data-glpi-form-editor-question]"),e.val());break;case"add-section":this.#D(e.closest(`\n                        [data-glpi-form-editor-active-form],\n                        [data-glpi-form-editor-active-section],\n                        [data-glpi-form-editor-active-horizontal-blocks],\n                        [data-glpi-form-editor-active-question],\n                        [data-glpi-form-editor-active-comment]\n                    `));break;case"delete-section":this.#F(e.closest("[data-glpi-form-editor-section]"));break;case"build-move-section-modal-content":this.#Q();o=false;break;case"reorder-sections":this.#U();break;case"merge-with-previous-section":this.#M(e.closest("[data-glpi-form-editor-section]"));break;case"collapse-section":this.#V(e.closest("[data-glpi-form-editor-section]"));break;case"duplicate-section":this.#H(e.closest("[data-glpi-form-editor-section]"));break;case"duplicate-question":this.#L(e.closest("[data-glpi-form-editor-question]"));break;case"duplicate-comment":this.#B(e.closest("[data-glpi-form-editor-comment]"));break;case"question-sort-update":break;case"add-comment":this.#j(e.closest(`\n                        [data-glpi-form-editor-active-form],\n                        [data-glpi-form-editor-active-section],\n                        [data-glpi-form-editor-active-horizontal-blocks],\n                        [data-glpi-form-editor-active-question],\n                        [data-glpi-form-editor-active-comment],\n                        [data-glpi-form-editor-horizontal-block-placeholder]\n                    `));break;case"delete-comment":this.#O(e.closest("[data-glpi-form-editor-comment]"));break;case"show-visibility-dropdown":this.#P(e.closest("[data-glpi-form-editor-block],[data-glpi-form-editor-section-details]"));break;case"show-validation-dropdown":this.#N(e.closest("[data-glpi-form-editor-block],[data-glpi-form-editor-section-details]"));break;case"add-horizontal-layout":this.#G(e.closest(`\n                        [data-glpi-form-editor-active-form],\n                        [data-glpi-form-editor-active-section],\n                        [data-glpi-form-editor-active-horizontal-blocks],\n                        [data-glpi-form-editor-active-question],\n                        [data-glpi-form-editor-active-comment]\n                    `));break;case"delete-horizontal-layout":this.#R(e.closest("[data-glpi-form-editor-horizontal-blocks-container]"));break;case"add-horizontal-layout-slot":this.#X(e.closest("[data-glpi-form-editor-horizontal-blocks]"));break;case"remove-horizontal-layout-slot":this.#W(e.closest("[data-glpi-form-editor-horizontal-block-placeholder]"));break;case"copy-uuid":this.#J(e.closest("[data-glpi-form-editor-question"));break;case"queue-preview":this.#d=true;break;case"stop-propagation":break;default:throw new Error(`Unknown action: ${t}`)}if(o){setHasUnsavedChanges(true)}this.#m()}computeState(){const t={question:0,comment:0};const e=$(this.#t).find("[data-glpi-form-editor-section]");e.each((e,i)=>{this.#K($(i).find("[data-glpi-form-editor-section-details]"),"section",e);this.#Y($(i),e);this.#Z($(i));const o=$(i).find("[data-glpi-form-editor-section-blocks]").children("[data-glpi-form-editor-block], [data-glpi-form-editor-horizontal-blocks-container]");o.each((e,o)=>{let a=$(o);const n=$(o).is("[data-glpi-form-editor-horizontal-blocks-container]");if(n){a=$(o).find("[data-glpi-form-editor-block], [data-glpi-form-editor-horizontal-block-placeholder]")}a.each((o,a)=>{if($(a).is("[data-glpi-form-editor-horizontal-block-placeholder]")){return}const s=$(a).is("[data-glpi-form-editor-question]")?"question":"comment";this.#K($(a),s,t[s]);this.#tt($(a),e,n?o:-1);this.#Z($(a));this.#et($(a),$(i));t[s]++})})})}#m(){this.#it();this.#ot();this.#at();this.#nt()}#K(t,e,i){const o=t.find("input[name], select[name], textarea[name]");o.each((t,o)=>{const a=$(o).attr("name");if(!$(o).data("glpi-form-editor-original-name")){$(o).attr("data-glpi-form-editor-original-name",a)}let n=$(o).data("glpi-form-editor-original-name");let s="";if(e==="section"){s=`_sections[${i}]`}else if(e==="question"){s=`_questions[${i}]`;const t=$(o).attr("data-glpi-form-editor-specific-question-extra-data")!==undefined;if(t){s+=`[extra_data]`}}else if(e==="comment"){s=`_comments[${i}]`}else if(e==="temp"){s=`_temp[${i}]`}else{throw new Error(`Unknown item type: ${e}`)}let r="";const d=new RegExp(/\[([\w-[\]]*)\]$/,"g");if(typeof n==="string"&&d.test(n)){r=n.match(d);n=n.replace(r,"")}$(o).attr("name",`${s}[${n}]${r}`)})}#Y(t,e){this.#st(t,"rank",e)}#tt(t,e,i=null){this.#st(t,"vertical_rank",e);this.#st(t,"horizontal_rank",i);const o=t.find("input[name='horizontal_rank'], input[data-glpi-form-editor-original-name='horizontal_rank']");o.prop("disabled",i===null)}#Z(t){const e=this.#rt(t,"uuid");if(e==""){this.#st(t,"uuid",getUUID())}}#et(t,e){const i=this.#rt(e,"uuid");this.#st(t,"forms_sections_uuid",i)}#b(t){const e=$(t.target.container).closest("[data-glpi-form-editor-question-description]");if(e.length>0){this.#dt(e,t.level.content)}}#$(t){const e=$(t.target).closest("html").find("body");const i=e.closest("#tinymce").data("id");const o=$(`#${i}`);this.#q(o.closest('[data-glpi-form-editor-on-click="set-active"]'))}#c(){const t=document.body.offsetHeight;const e=$(this.#t).offset().top;const i=1;let o=t-e-i;if($("#debug-toolbar").length>0){const t=$("#debug-toolbar").height();o-=t}$(this.#t).css("height",`${o}`)}#w(){const t=$("#main-form button[name=update]");t.find(".ti-plus").removeClass("ti-plus").addClass("ti-device-floppy");t.find(".add-label").text(_.unescape(__("Save")));t.prop("title",_.unescape(__("Save")));const e=$("#main-form button[name=delete]");e.removeClass("d-none");this.#e=false}#dt(t,e){const i=document.createElement("div");i.innerHTML=e;const o=i.textContent||i.innerText||"";const a=o.length;if(a==0){t.attr("data-glpi-form-editor-question-extra-details","")}else{t.removeAttr("data-glpi-form-editor-question-extra-details")}}#q(t){const e=["form","section","question","comment","horizontal-blocks","horizontal-block-placeholder"];e.forEach(e=>{$(this.#t).find(`[data-glpi-form-editor-active-${e}]`).filter((i,o)=>{if(e==="form"||e==="section"){return true}return t===null||!$(o).is(t)&&$(o).has(t).length===0}).removeAttr(`data-glpi-form-editor-active-${e}`)});if(t===null){return}t.find("select[data-glpi-loaded=false]").each(function(){const t=$(this).attr("id");const e=window.select2_configs[t];if(e.type==="ajax"){setupAjaxDropdown(e)}else if(e.type==="adapt"){setupAdaptDropdown(e)}$(this).attr("data-glpi-loaded","true")});setTimeout(()=>{if(t!==null){e.forEach(e=>{e=CSS.escape(e);if(t.data(`glpi-form-editor-${e}-details`)!==undefined){t.closest(`[data-glpi-form-editor-${e}]`).attr(`data-glpi-form-editor-active-${e}`,"")}else if(t.data(`glpi-form-editor-${e}`)!==undefined){t.attr(`data-glpi-form-editor-active-${e}`,"")}});const i=t.closest("[data-glpi-form-editor-section]");if(i.hasClass("section-collapsed")){return}t.addClass("active");const o=t.closest("section[data-glpi-form-editor-horizontal-blocks]");if(o.length>0){o.closest("section[data-glpi-form-editor-horizontal-blocks-container]").attr("data-glpi-form-editor-active-horizontal-blocks","")}if(t.length>0){this.#lt(t)}}})}#ct(t,e){let i;let o;if(t.data("glpi-form-editor-question")!==undefined||t.data("glpi-form-editor-comment")!==undefined){i=t;o="after"}else if(t.data("glpi-form-editor-section")!==undefined){i=t.closest("[data-glpi-form-editor-section]").find("[data-glpi-form-editor-section-blocks]");o="prepend"}else if(t.data("glpi-form-editor-form")!==undefined){i=$(this.#t).find("[data-glpi-form-editor-section]:last-child").find("[data-glpi-form-editor-section-blocks]:last-child");o="append"}else if(t.data("glpi-form-editor-horizontal-blocks-container")!==undefined){i=t;o="after"}else if(t.data("glpi-form-editor-horizontal-blocks")!==undefined){i=t;o="append"}else if(t.data("glpi-form-editor-horizontal-block-placeholder")!==undefined){i=t;o="after";setTimeout(()=>this.#W(t),0)}else{throw new Error("Unexpected target")}return this.#pt(e,i,o)}#E(t){const e=this.#f(this.#i).children();const i=this.#ct(t,e);this.#Z(i);this.#q(i);i.find("[data-glpi-form-editor-question-details-name]")[0].focus();this.#g(i)}#z(t){if(!this.#mt("question",t)){return}t.find('[data-bs-toggle="tooltip"]').tooltip("dispose");if($(this.#t).find("[data-glpi-form-editor-question]").length==1&&this.#ft()==1){this.#gt()}else{if(t.prev().length>0){this.#q(t.prev())}else{this.#q(t.closest("[data-glpi-form-editor-section]"))}}const e=t.parent();t.remove();if(e.is("[data-glpi-form-editor-horizontal-blocks]")&&e.find("[data-glpi-form-editor-block], [data-glpi-form-editor-horizontal-block-placeholder]").length===0){this.#R(e)}}#ht(t,e){const i=this.#rt(e,"uuid");if(!i){return{conditionsUsingItem:[],destinationsUsingItem:[]}}const o=`${t}-${i}`;const a=$("[data-glpi-conditions-editor-item]").filter((t,e)=>e.value===o);const n=Object.values(this.#a).filter(t=>t.conditions&&Object.values(t.conditions).some(t=>t.item===o));return{conditionsUsingItem:a,destinationsUsingItem:n}}#mt(t,e){const i=this.#ht(t,e);if(i.conditionsUsingItem.length>0||i.destinationsUsingItem.length>0){this.#ut(t,i.conditionsUsingItem,i.destinationsUsingItem,"deletion");return false}return true}async#vt(t){try{const e=await $.post(`${CFG_GLPI.root_doc}/Form/Condition/Editor/SupportedValueOperators`,t);return e.operators||[]}catch(t){console.error("Error fetching supported value operators:",t);return[]}}async#bt(t,e){const i=this.#ht("question",t);const o={type:e,uuid:this.#rt(t,"uuid"),name:this.#rt(t,"name")||"",extra_data:this.#$t(t[0])};const a=await this.#vt(o);const n=i.conditionsUsingItem.filter((t,e)=>!a.includes($(e).closest("[data-glpi-conditions-editor-condition]").find("[data-glpi-conditions-editor-value-operator]").val()));const s=i.destinationsUsingItem;if(n.length>0||s.length>0){this.#ut("question",i.conditionsUsingItem,i.destinationsUsingItem,"new_question_type");return false}return true}#ut(t,e,i,o){$(`[data-glpi-form-editor-item-has-conditions-modal="${CSS.escape(o)}"] [data-glpi-form-editor-item-has-conditions-modal-header]`).addClass("d-none").filter(`[data-glpi-form-editor-item-has-conditions-modal-header="${CSS.escape(t)}"]`).removeClass("d-none");const a=[];e.each((t,e)=>{const i=$(e).closest("[data-glpi-form-editor-block]");if(i.length>0){a.push({name:this.#rt(i,"name"),uuid:this.#rt(i,"uuid"),type:"question",element:i})}else{const t=$(e).closest("[data-glpi-form-editor-section]");if(t.length>0){a.push({name:this.#rt(t,"name"),uuid:this.#rt(t,"uuid"),type:"section",element:t})}}});i.forEach(t=>{a.push({name:t.name,type:"destination"})});const n=$(`[data-glpi-form-editor-item-has-conditions-modal="${CSS.escape(o)}"] [data-glpi-form-editor-item-has-conditions-list]`);n.empty();const s=$(`[data-glpi-form-editor-item-has-conditions-modal="${CSS.escape(o)}"] [data-glpi-form-editor-item-has-conditions-item-template]`).html();a.forEach(t=>{const e=$(s);const i=e.find("[data-glpi-form-editor-item-has-conditions-item-name]");i.text(t.name);if(t.uuid){i.attr("data-glpi-form-editor-item-has-conditions-item-uuid",t.uuid)}i.attr("data-glpi-form-editor-item-has-conditions-item-type",t.type);if(t.type==="destination"){const t=$('[data-bs-target^="#tab-Glpi_Form_Destination_FormDestination_"]');i.attr("href",t.attr("href"))}n.append(e)});n.find('[data-glpi-form-editor-item-has-conditions-item-selector][href="#"]').on("click",t=>{t.preventDefault();$(`[data-glpi-form-editor-item-has-conditions-modal="${CSS.escape(o)}"]`).modal("hide");const e=$(t.currentTarget);const i=e.data("glpi-form-editor-item-has-conditions-item-uuid");const a=e.data("glpi-form-editor-item-has-conditions-item-type");this.#yt(a,i)});$(`[data-glpi-form-editor-item-has-conditions-modal="${CSS.escape(o)}"]`).modal("show")}#yt(t,e){if(!e||!t){return}let i;if(t==="question"){i=$(this.#t).find("[data-glpi-form-editor-question]").filter((t,i)=>this.#rt($(i),"uuid")===e).first()}else if(t==="section"){i=$(this.#t).find("[data-glpi-form-editor-section-details]").filter((t,i)=>this.#rt($(i),"uuid")===e).first()}if(i&&i.length>0){const t=i.closest("[data-glpi-form-editor-section]");if(t.hasClass("section-collapsed")){this.#V(t)}this.#q(i);i.get(0).scrollIntoView({behavior:"smooth",block:"center",inline:"nearest"})}}#f(t){return $(this.#o).find(`[data-glpi-form-editor-question-template="${CSS.escape(t)}"]`)}#pt(t,e,i="append",o=false){const a=t.clone();const n=[];const s=[];const r=[];a.find("textarea").each(function(){let t=$(this).attr("id");const e=_.cloneDeep(window.tinymce_editor_configs[t]);const i=getUUID();$(this).attr("id",`_tinymce_${i}`);t=$(this).attr("id");e.selector=`#${CSS.escape(t)}`;window.tinymce_editor_configs[t]=e;const o=$(this).parent().find("div[data-glpi-tinymce-init-on-demand-render]");if(o.length>0){o.attr("data-glpi-tinymce-init-on-demand-render",t)}else{n.push(e)}});a.find("select").each(function(){let e;if(o){e=$(this).select2("data");$(this).removeClass("select2-hidden-accessible");$(this).removeAttr("data-select2-id");$(this).next(".select2-container").remove();t.find(`#${CSS.escape($(this).attr("id"))}`).each(function(){const t=$(this).attr("data-glpi-form-editor-original-id")??$(this).attr("id");const i={...window.select2_configs[t]};i.field_id=$(this).attr("id");s.push(i);r[$(this).attr("id")]=e;$(this).select2("destroy")})}const i=$(this).attr("data-glpi-form-editor-original-id")??$(this).attr("id");const n={...window.select2_configs[i]};if(i!==undefined&&n!==undefined){const t=getUUID();const o=`_config_${t}`;$(this).attr("id",o);$(this).attr("data-glpi-form-editor-original-id",i);if(a.find(`label[for="${CSS.escape(i)}"]`).length>0){a.find(`label[for="${CSS.escape(i)}"]`).attr("for",o)}if($(this).hasClass("select2-hidden-accessible")===false&&n!==undefined){n.field_id=o;s.push(n);if(e){r[o]=e}}}});if(o){this.#K(a,"temp",getUUID())}a.find("input[id]").each(function(){const t=$(this).attr("id");const e=a.find(`label[for="${CSS.escape(t)}"]`);if(e.length==0){return}const i=getUUID();const o=`${t}_${i}`;$(this).attr("id",o);e.each(function(){$(this).attr("for",o)})});switch(i){case"append":a.appendTo(e);break;case"prepend":a.prependTo(e);break;case"before":a.insertBefore(e);break;case"after":a.insertAfter(e);break;default:throw new Error(`Unknown action: ${i}`)}n.forEach(t=>tinyMCE.init(t));s.forEach(t=>{if(t.type==="ajax"){const e=setupAjaxDropdown(t);if(r[t.field_id]){e.find("option").remove();for(const i of r[t.field_id]){const t=new Option(i.text,i.id,true,true);e.append(t).trigger("change");e.trigger("select2:select",{data:i})}}}else if(t.type==="adapt"){const e=setupAdaptDropdown(t);if(r[t.field_id]){for(const i of r[t.field_id]){e.val(i.id).trigger("change")}}}});const d=a.find('[data-bs-toggle="tooltip"]');[...d].map(t=>new bootstrap.Tooltip(t));const l=a.find('[data-bs-toggle="popover"]');[...l].map(t=>new bootstrap.Popover(t));if(o){this.computeState()}return a}#$t(t){const e={};const i=t.querySelectorAll("[data-glpi-form-editor-specific-question-extra-data]");for(const t of i){if(t.type==="checkbox"&&t.checked===false){continue}let i=t.dataset.glpiFormEditorOriginalName;if(i===undefined){i=t.name}const o=i.indexOf("[")!==-1&&i.indexOf("]")!==-1&&i.indexOf("[]")===-1;if(o){const o=i.match(/^(.*)\[(.*)\]$/);if(o===null){throw new Error(`Unexpected input name: ${i}`)}if(e[o[1]]===undefined){e[o[1]]={}}e[o[1]][o[2]]=t.value}else{e[i]=t.value}}return e}#rt(t,e){if(t.data("glpi-form-editor-section")!==undefined){t=t.find("[data-glpi-form-editor-section-details]")}let i=t.find(`input[name="${CSS.escape(e)}"]`);if(i.length>0){return t.find(`input[name="${CSS.escape(e)}"]`).val()}i=t.find(`input[data-glpi-form-editor-original-name="${CSS.escape(e)}"]`);if(i.length>0){return t.find(`input[data-glpi-form-editor-original-name="${CSS.escape(e)}"]`).val()}throw new Error(`Field not found: ${e}`)}#st(t,e,i){if(t.data("glpi-form-editor-section")!==undefined){t=t.find("[data-glpi-form-editor-section-details]")}let o=t.find(`input[name="${CSS.escape(e)}"]`);if(o.length>0){return t.find(`input[name="${CSS.escape(e)}"]`).val(i)}o=t.find(`input[data-glpi-form-editor-original-name="${CSS.escape(e)}"]`);if(o.length>0){return t.find(`input[data-glpi-form-editor-original-name="${CSS.escape(e)}"]`).val(i)}throw new Error(`Field not found: ${e}`)}#kt(t,e){const i=t.find("[data-glpi-form-editor-question-type-specific]");if(e){if(i.find(".glpi-form-editor-loading-overlay").length===0){const t=$(`\n                    <div class="glpi-form-editor-loading-overlay position-absolute top-0 start-0 w-100 h-100 d-flex align-items-center justify-content-center bg-white bg-opacity-75">\n                        <div class="spinner-border spinner-border-sm text-secondary" role="status">\n                            <span class="visually-hidden">${__("Loading...")}</span>\n                        </div>\n                    </div>\n                `);i.css("position","relative").append(t)}i.css({opacity:"0.7","pointer-events":"none"}).attr("data-glpi-loading","true")}else{i.find(".glpi-form-editor-loading-overlay").remove();i.css({opacity:"","pointer-events":"",position:""}).removeAttr("data-glpi-loading")}}async#T(t,e){const i=this.#rt(t,"category");if(i===e){return}const o=$(this.#o).find(`option[data-glpi-form-editor-question-type="${CSS.escape(e)}"]`);this.#kt(t,true);if(!await this.#bt(t,o.first().val())){this.#kt(t,false);const e=t.find('[data-glpi-form-editor-on-change="change-question-type-category"]').data("previous-value");if(e!==undefined){t.find('[data-glpi-form-editor-on-change="change-question-type-category"]').val(e).trigger("change.select2")}return false}this.#kt(t,false);const a=t.find("[data-glpi-form-editor-question-type-selector]");a.children().remove();this.#pt(o,a);this.#st(t,"category",e);const n=a.parent();if(o.length<=1){n.addClass("d-none")}else{n.removeClass("d-none")}a.trigger("change")}async#A(t,e){const i=this.#rt(t,"type");if(i===e){return}this.#kt(t,true);if(!await this.#bt(t,e)){this.#kt(t,false);const e=t.find('[data-glpi-form-editor-on-change="change-question-type"]').data("previous-value");if(e!==undefined){t.find('[data-glpi-form-editor-on-change="change-question-type"]').val(e).trigger("change.select2")}return}this.#kt(t,false);const o=this.#n[i].extractDefaultValue(t);const a=t.find("[data-glpi-form-editor-question-type-specific]");a.children().remove();const n=t.find("[data-glpi-form-editor-specific-question-options]");n.children().remove();const s=this.#f(e).find("[data-glpi-form-editor-question-type-specific]").children();const r=this.#f(e).find("[data-glpi-form-editor-specific-question-options]").children();this.#pt(s,a);this.#pt(r,n);this.#st(t,"type",e);const d=this.#f(e).find("[data-glpi-form-editor-question-details]").data("glpi-form-editor-allow-anonymous");t.find("[data-glpi-form-editor-blacklisted-question-type-warning]").toggleClass("d-none",d==1);this.#n[e].convertDefaultValue(t,o);if(this.#s[e]!==undefined){const i=t.find("[data-glpi-form-editor-question-sub-type-selector]");i.closest("div").removeClass("d-none");i.attr("disabled",false);i.find("optgroup, option").remove();const o=this.#s[e].subtypes;for(const t in o){const e=$(`<optgroup label="${_.escape(t)}"></optgroup>`);for(const[i,a]of Object.entries(o[t])){const t=$(`<option value="${_.escape(i)}">${_.escape(a)}</option>`);e.append(t)}i.append(e)}if(this.#s[e].default_value){i.val(this.#s[e].default_value)}i.attr("name",this.#s[e].field_name);i.attr("aria-label",this.#s[e].field_aria_label);i.removeAttr("data-glpi-form-editor-original-name");i.trigger("change")}else{t.find("[data-glpi-form-editor-question-sub-type-selector]").attr("disabled",true).closest("div").addClass("d-none")}$(document).trigger("glpi-form-editor-question-type-changed",[t,e])}#x(t,e){$(document).trigger("glpi-form-editor-question-sub-type-changed",[t,e])}#D(t){let e;let i;let o;if(t.data("glpi-form-editor-question")!==undefined||t.data("glpi-form-editor-comment")!==undefined){e=t.closest("[data-glpi-form-editor-section]");i="after";o=$(t).nextAll()}else if(t.data("glpi-form-editor-section")!==undefined){e=t.closest("[data-glpi-form-editor-section]");i="after";o=$(t).closest("[data-glpi-form-editor-section]").find("[data-glpi-form-editor-question]")}else if(t.data("glpi-form-editor-form")!==undefined){e=t.closest("[data-glpi-form-editor-form]").find("[data-glpi-form-editor-section]:last-child");i="after";o=null}else if(t.data("glpi-form-editor-horizontal-blocks-container")!==undefined){e=t;i="after";o=$(t).nextAll()}else{throw new Error("Unexpected target")}const a=$(this.#o).find("[data-glpi-form-editor-section-template]").children();const n=this.#pt(a,e,i);if(o!==null&&o.length>0){o.detach().appendTo(n.find("[data-glpi-form-editor-section-blocks]"));o.each((t,e)=>{this.#Ct($(e))})}this.#q(n.find("[data-glpi-form-editor-section-details]"));this.#g(n);n.find("[data-glpi-form-editor-section-details-name]")[0].focus()}#F(t){if(!this.#mt("section",t)){return}if(t.prev().length==0){if(t.next().length>0&&this.#ft()>2){this.#q(t.next())}else{this.#gt()}}else{const e=t.prev().find("[data-glpi-form-editor-question]");if(e.length>0){this.#q(e.last())}else{if(this.#ft()==2){this.#gt()}else{this.#q(t.prev())}}}t.remove()}#j(t){const e=$(this.#o).find("[data-glpi-form-editor-comment-template]").children();const i=this.#ct(t,e);this.#Z(i);this.#q(i);i.find("[data-glpi-form-editor-comment-details-name]")[0].focus();this.#g(i)}#O(t){if(!this.#mt("comment",t)){return}t.find('[data-bs-toggle="tooltip"]').tooltip("dispose");if($(this.#t).find("[data-glpi-form-editor-comment]").length==1&&this.#ft()==1){this.#gt()}else{if(t.prev().length>0){this.#q(t.prev())}else{this.#q(t.closest("[data-glpi-form-editor-section]"))}}const e=t.parent();t.remove();if(e.is("[data-glpi-form-editor-horizontal-blocks]")&&e.find("[data-glpi-form-editor-block], [data-glpi-form-editor-horizontal-block-placeholder]").length===0){this.#R(e)}}#it(){const t=$(this.#t).find("[data-glpi-form-editor-block]").length;if(t==0){$("[data-glpi-form-editor-on-click='add-section']").addClass("d-none")}else{$("[data-glpi-form-editor-on-click='add-section']").removeClass("d-none")}}#ft(){return $(this.#t).find("[data-glpi-form-editor-section]").length}#h(){return $(this.#t).find("[data-glpi-form-editor-question]").length}#at(){if(this.#ft()<=1){$(this.#t).find("[data-glpi-form-editor-section-details]").addClass("d-none")}else{$(this.#t).find("[data-glpi-form-editor-section-details]").removeClass("d-none")}}#nt(){$(this.#t).find(`[data-glpi-form-editor-on-click="merge-with-previous-section"]`).removeClass("d-none");$(this.#t).find(`[data-glpi-form-editor-section]:first-child`).find(`[data-glpi-form-editor-on-click="merge-with-previous-section"]`).addClass("d-none")}#g(t){t.each((t,e)=>{const i=$(e).find("[data-glpi-form-editor-section-blocks], [data-glpi-form-editor-horizontal-blocks], [data-glpi-form-editor-question-drag-merge], [data-glpi-form-editor-horizontal-block-placeholder]");i.each((t,e)=>{const i=$(e);const o={handle:"[data-glpi-form-editor-question-handle]",items:"[data-glpi-form-editor-block], [data-glpi-form-editor-horizontal-block-placeholder]",acceptFrom:"[data-glpi-form-editor-section-blocks], [data-glpi-form-editor-horizontal-blocks]",placeholder:'<section class="glpi-form-editor-drag-question-placeholder"></section>'};if(i.is("[data-glpi-form-editor-horizontal-blocks]")){o.maxItems=4}sortable(i,o)})});t.find("[data-glpi-form-editor-section-blocks], [data-glpi-form-editor-horizontal-blocks], [data-glpi-form-editor-question-drag-merge], [data-glpi-form-editor-horizontal-block-placeholder]").on("sortupdate",t=>{this.#_("question-sort-update",null,t)});t.find("[data-glpi-form-editor-section-blocks], [data-glpi-form-editor-horizontal-blocks], [data-glpi-form-editor-question-drag-merge], [data-glpi-form-editor-horizontal-block-placeholder]").on("sortstart",t=>{$(t.detail.item).addClass("form-editor-no-merge");setTimeout(()=>{$(t.detail.item).addClass("d-none")},0);$(this.#t).addClass("disable-focus").attr("data-glpi-form-editor-sorting","");if($(t.detail.item).is("[data-glpi-form-editor-active-question],[data-glpi-form-editor-active-comment]")){$(t.detail.item).attr("data-glpi-form-editor-restore-active-state","")}this.#q(null)});t.find("[data-glpi-form-editor-section-blocks], [data-glpi-form-editor-horizontal-blocks], [data-glpi-form-editor-question-drag-merge], [data-glpi-form-editor-horizontal-block-placeholder]").on("sortstop",t=>{if($(t.detail.item).hasClass("sortable-dragging")){return}if($(t.detail.origin.container).data("glpi-form-editor-horizontal-blocks")!==undefined&&$(t.detail.origin.container).find("[data-glpi-form-editor-block], [data-glpi-form-editor-horizontal-block-placeholder]").length===0){this.#R($(t.detail.origin.container).parent("[data-glpi-form-editor-horizontal-blocks-container]"))}if($(t.detail.item).parent().data("glpi-form-editor-horizontal-block-placeholder")!==undefined){const e=$(t.detail.item).parent();$(t.detail.item).insertAfter(e);e.remove()}if($(t.detail.item).parent().data("glpi-form-editor-question-drag-merge")!==undefined){const e=$(t.detail.item).parents("[data-glpi-form-editor-block]").addBack();this.#St(e)}this.#Ct($(t.detail.item));$(this.#t).removeClass("disable-focus").removeAttr("data-glpi-form-editor-sorting");$(".content-editable-tinymce").removeClass("simulate-focus");const e=$(t.detail.item).attr("data-glpi-form-editor-restore-active-state");if(e!==undefined){$(t.detail.item).removeAttr("data-glpi-form-editor-restore-active-state");this.#q($(t.detail.item))}$(t.detail.item).removeClass("form-editor-no-merge");$(t.detail.item).removeClass("d-none")})}#Q(){const t=$(this.#t).find("[data-glpi-form-editor-move-section-modal-items]");t.children().remove();$(this.#t).find("[data-glpi-form-editor-section]").each((e,i)=>{const o=this.#rt($(i),"name");const a=$("[data-glpi-form-editor-move-section-modal-item-template]").clone();const n=getUUID();$(i).attr("data-glpi-form-editor-move-section-modal-uuid",n);a.find("[data-glpi-form-editor-move-section-modal-item-section-key]").attr("data-glpi-form-editor-move-section-modal-item-section-key",n);a.find("[data-glpi-form-editor-move-section-modal-item-section-key]").attr("aria-label",_.unescape(__("Move section: %1$d")).replace("%1$d",o));a.find("[data-glpi-form-editor-move-section-modal-item-section-name]").text(o);a.removeAttr("data-glpi-form-editor-move-section-modal-item-template");t.append(a)});sortable($("[data-glpi-form-editor-move-section-modal-items]"),{handle:"[data-glpi-form-editor-section-handle]",placeholderClass:"glpi-form-editor-drag-section-placeholder"})}#U(){$(this.#t).find("[data-glpi-form-editor-move-section-modal]").modal("hide");$(this.#t).find("[data-glpi-form-editor-move-section-modal-items]").children().each((t,e)=>{const i=$(e).find("[data-glpi-form-editor-move-section-modal-item-section-key]").data("glpi-form-editor-move-section-modal-item-section-key");const o=$(this.#t).find(`[data-glpi-form-editor-move-section-modal-uuid="${CSS.escape(i)}"]`);o.remove().appendTo($(this.#t).find("[data-glpi-form-editor-blocks]"))});$(this.#t).find("[data-glpi-form-editor-section]").each((t,e)=>{this.#Ct($(e))})}#Ct(t){const e=this.#It(t);this.#_t(e)}#M(t){const e=t.prev();const i=t.find("[data-glpi-form-editor-section-blocks]").children();i.detach().appendTo(e.find("[data-glpi-form-editor-section-blocks]"));i.each((t,e)=>{this.#Ct($(e))});t.remove()}#V(t){t.toggleClass("section-collapsed");this.#wt(t)}#wt(t){const e=t.find("[data-glpi-form-editor-block]").length;const i=t.find("span[data-glpi-form-editor-section-block-badge]");i.html(i.html().trim().replace(/^\d+\s/,`${e} `))}#H(t){const e=this.#It(t);const i=this.#pt(t,t,"after",true);this.#_t(e);this.#st(i,"uuid","");i.find("[data-glpi-form-editor-question]").each((t,e)=>{this.#st($(e),"uuid","")});this.#q(i);this.#g(i)}#L(t){const e=this.#It(t);const i=this.#pt(t,t,"after",true);this.#_t(e);this.#st(i,"uuid","");this.#q(i);t.closest("[data-glpi-form-editor-horizontal-blocks]").find("[data-glpi-form-editor-horizontal-block-placeholder]").first().remove();$(document).trigger("glpi-form-editor-question-duplicated",[t,i])}#B(t){const e=this.#It(t);const i=this.#pt(t,t,"after");this.#_t(e);this.#st(i,"uuid","");this.#q(i);t.closest("[data-glpi-form-editor-horizontal-blocks]").find("[data-glpi-form-editor-horizontal-block-placeholder]").first().remove()}#ot(){$(this.#t).find("[data-glpi-form-editor-empty-div]").remove();const t=$(this.#t).find("[data-glpi-form-editor-section]");t.each((t,e)=>{const i=$(e).find("[data-glpi-form-editor-section-blocks]");if(i.children().length==0){i.append('<div data-glpi-form-editor-empty-div style="height: 1px"></div>')}})}#It(t){const e=[];t.find("textarea").each((t,i)=>{const o=$(i).prop("id");const a=tinymce.get(o);if(a){a.destroy();e.push(o)}});return e}#_t(t){t.forEach(t=>{tinymce.init(window.tinymce_editor_configs[t])})}#C(){if(hasUnsavedChanges()){$(this.#t).find("[data-glpi-form-editor-preview-actions]").find("[data-glpi-form-editor-preview-action]").addClass("d-none");$(this.#t).find("[data-glpi-form-editor-preview-actions]").find("[data-glpi-form-editor-save-and-preview-action]").removeClass("d-none")}else{$(this.#t).find("[data-glpi-form-editor-preview-actions]").find("[data-glpi-form-editor-preview-action]").removeClass("d-none");$(this.#t).find("[data-glpi-form-editor-preview-actions]").find("[data-glpi-form-editor-save-and-preview-action]").addClass("d-none")}}#gt(){const t=$(this.#t).find("[data-glpi-form-editor-form-details]");this.#q(t)}#P(t){t.find("[data-glpi-form-editor-visibility-dropdown-container]").removeClass("d-none");const e=t.find("[data-glpi-form-editor-visibility-dropdown-container]").find("[data-glpi-form-editor-visibility-dropdown]");bootstrap.Dropdown.getOrCreateInstance(e[0]).show()}#S(t,e){let i=null;if(t.find(`[data-glpi-editor-visibility-badge="${CSS.escape(e)}"]`).length>0){i="visibility"}else if(t.find(`[data-glpi-editor-validation-badge="${CSS.escape(e)}"]`).length>0){i="validation"}t.find(`[data-glpi-editor-${CSS.escape(i)}-badge]`).removeClass("d-flex").addClass("d-none");t.find(`[data-glpi-editor-${CSS.escape(i)}-badge="${CSS.escape(e)}"]`).removeClass("d-none").addClass("d-flex")}#I(t,e){t.find("[data-glpi-editor-validation-conditions-count-badge], [data-glpi-editor-visibility-conditions-count-badge]").html(e)}#N(t){t.find("[data-glpi-form-editor-validation-dropdown-container]").removeClass("d-none");const e=t.find("[data-glpi-form-editor-validation-dropdown-container]").find("[data-glpi-form-editor-validation-dropdown]");bootstrap.Dropdown.getOrCreateInstance(e[0]).show()}#qt(){this.computeState();const t=[];$(this.#t).find("[data-glpi-form-editor-section]").each((e,i)=>{t.push({uuid:this.#rt($(i),"uuid"),name:this.#rt($(i),"name")})});return t}#Et(){this.computeState();const t=[];$(this.#t).find("[data-glpi-form-editor-question]").each((e,i)=>{t.push({uuid:this.#rt($(i),"uuid"),name:this.#rt($(i),"name"),type:this.#rt($(i),"type"),extra_data:this.#$t(i)})});return t}#zt(){this.computeState();const t=[];$(this.#t).find("[data-glpi-form-editor-comment]").each((e,i)=>{t.push({uuid:this.#rt($(i),"uuid"),name:this.#rt($(i),"name")})});return t}async#y(t){let e=this.#Tt(t);if(e===null){const i=this.#rt(t.closest("[data-glpi-form-editor-block], [data-glpi-form-editor-section-details], [data-glpi-form-editor-container]"),"uuid");const o=t.closest("[data-glpi-form-editor-condition-type]").data("glpi-form-editor-condition-type");e=new GlpiFormConditionVisibilityEditorController(t[0],i,o,this.#qt(),this.#Et(),this.#zt());t.attr("data-glpi-editor-condition-controller-index",this.#r.length);this.#r.push(e)}else{e.setFormSections(this.#qt());e.setFormQuestions(this.#Et());e.setFormComments(this.#zt())}e.renderEditor()}async#k(t){let e=this.#Tt(t);if(e===null){const i=this.#rt(t.closest("[data-glpi-form-editor-block], [data-glpi-form-editor-section-details], [data-glpi-form-editor-container]"),"uuid");const o=t.closest("[data-glpi-form-editor-condition-type]").data("glpi-form-editor-condition-type");e=new GlpiFormConditionValidationEditorController(t[0],i,o,this.#qt(),this.#Et(),this.#zt());t.attr("data-glpi-editor-condition-controller-index",this.#r.length);this.#r.push(e)}else{e.setFormSections(this.#qt());e.setFormQuestions(this.#Et());e.setFormComments(this.#zt())}e.renderEditor()}#Tt(t){const e=t.data("glpi-editor-condition-controller-index");return this.#r[e]??null}#u(){$(this.#t).find("[data-glpi-editor-refresh-checked]").removeProp("checked");$(this.#t).find("[data-glpi-editor-refresh-checked]").prop("checked",true)}#G(t){const e=$(this.#o).find("[data-glpi-form-editor-horizontal-block-template]").children();const i=this.#ct(t,e);this.#g(i)}#R(t){t.find('[data-bs-toggle="tooltip"]').tooltip("dispose");const e=t.find("[data-glpi-form-editor-block]");e.insertAfter(t);t.prev("[data-glpi-form-editor-horizontal-blocks-fix-sortable-issue]").remove();t.next("[data-glpi-form-editor-horizontal-blocks-fix-sortable-issue]").remove();t.remove()}#X(t){const e=$(this.#o).find("[data-glpi-form-editor-horizontal-block-placeholder-template]").children();const i=this.#ct(t,e);this.#g(t);this.#q(i);t.find('[data-bs-toggle="tooltip"]').tooltip("dispose")}#W(t){t.find('[data-bs-toggle="tooltip"]').tooltip("dispose");if(t.parent().find("[data-glpi-form-editor-block], [data-glpi-form-editor-horizontal-block-placeholder]").length==1){this.#R(t.parent())}else{t.remove()}}#St(t){const e=$(this.#o).find("[data-glpi-form-editor-horizontal-block-template]").children();const i=this.#pt(e,t.first(),"after");t.detach().appendTo(i.find("[data-glpi-form-editor-horizontal-blocks]"));this.#g(i);i.find("[data-glpi-form-editor-horizontal-block-placeholder]").remove()}#J(t){this.computeState();const e=this.#rt(t,"uuid");navigator.clipboard.writeText(e);glpi_toast_info(__("UUID copied successfully to clipboard."))}#lt(t){const e={behavior:"smooth",block:"nearest"};t[0].scrollIntoView(e);setTimeout(()=>{t[0].scrollIntoView(e)},100);setTimeout(()=>{t[0].scrollIntoView(e)},200);setTimeout(()=>{t[0].scrollIntoView(e)},500)}}